/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.compiler.xml.processes.AbstractNodeHandler;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.FaultNode;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FaultNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new FaultNode();
    }

    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String faultVariable;
        super.handleNode(node, element, uri, localName, parser);
        FaultNode faultNode = (FaultNode)node;
        String faultName = element.getAttribute("faultName");
        if (faultName != null && faultName.length() != 0) {
            faultNode.setFaultName(faultName);
        }
        if ((faultVariable = element.getAttribute("faultVariable")) != null && !"".equals(faultVariable)) {
            faultNode.setFaultVariable(faultVariable);
        }
    }

    public Class generateNodeFor() {
        return FaultNode.class;
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        String faultVariable;
        FaultNode faultNode = (FaultNode)node;
        this.writeNode("fault", faultNode, xmlDump, includeMeta);
        String faultName = faultNode.getFaultName();
        if (faultName != null && faultName.length() != 0) {
            xmlDump.append("faultName=\"" + faultName + "\" ");
        }
        if ((faultVariable = faultNode.getFaultVariable()) != null && faultVariable.length() != 0) {
            xmlDump.append("faultVariable=\"" + faultVariable + "\" ");
        }
        if (includeMeta && this.containsMetaData(faultNode)) {
            xmlDump.append(">" + EOL);
            this.writeMetaData(faultNode, xmlDump);
            this.endNode("fault", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

